	subroutine SHAPEQ(iout, idbg, Ne, Nn, V, D, Qce1, Qde1, Qce2, Qde2, &
			 ie, x, e)
! calculate nodal flux matrices

	implicit none
	integer iout, idbg
	integer Ne, Nn				! array parameters
	real*8 Qce1(4,4), Qde1(4,4)		! element arrays
	real*8 Qce2(4,4), Qde2(4,4)		! element arrays
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	real*8 V(Ne,2), D(Ne,2,2)		! global  arrays
	integer e

	integer i1, i2, i3, i4, m, k, ii, jj
	real*8 r, s, Jac, Jaci, dNdr(4,2), J(2,2), Ji(2,2)

!	write(idbg,'(a)') ' --- SHAPEQ ---'	! ### TEMPORARY ###

	i1 = ie(e,1)			! 1st node
	i2 = ie(e,2)			! 2nd node
	i3 = ie(e,3)			! 3rd node
	i4 = ie(e,4)			! 4th node
	
! calculate the nodal advection flux matrix, Qce
	Qce1 = 0.	! reset Qce1
	Qce2 = 0.	! reset Qce2
	do ii = 1,4
	  Qce1(ii,ii) = V(e,1)
	  Qce2(ii,ii) = V(e,2)
	enddo		! ii	

! calculate the nodal conduction flux matrix, Qde
	Qde1 = 0.	! reset Qde1
	Qde2 = 0.	! reset Qde2
	do ii = 1,4

! linear 2D shape functions
! Ni(r,s) = (1 +/- r)(1 +/- s) / 4 ; -1 < r, s < +1
	  if     (ii .eq. 1) then
	    r =-1.
	    s =-1.
	  else if(ii .eq. 2) then
	    r = 1.
	    s =-1.
	  else if(ii .eq. 3) then
	    r = 1.
	    s = 1.
	  else if(ii .eq. 4) then
	    r =-1.
	    s = 1.
	  endif

	  dNdr(1,1) =-0.25d0 * (1.-s)				! dN1(r,s)/dr
	  dNdr(2,1) = 0.25d0 * (1.-s)				! dN2(r,s)/dr
	  dNdr(3,1) = 0.25d0 * (1.+s)				! dN3(r,s)/dr
	  dNdr(4,1) =-0.25d0 * (1.+s)				! dN4(r,s)/dr

	  dNdr(1,2) =-0.25d0 * (1.-r)				! dN1(r,s)/ds
	  dNdr(2,2) =-0.25d0 * (1.+r)				! dN2(r,s)/ds
	  dNdr(3,2) = 0.25d0 * (1.+r)				! dN3(r,s)/ds
	  dNdr(4,2) = 0.25d0 * (1.-r)				! dN4(r,s)/ds

! Jij is the Jacobian matrix
	  J(1,1) = dNdr(1,1)*x(i1,1) + dNdr(2,1)*x(i2,1) + &
		   dNdr(3,1)*x(i3,1) + dNdr(4,1)*x(i4,1)	! x,r
	  J(1,2) = dNdr(1,2)*x(i1,1) + dNdr(2,2)*x(i2,1) + &
		   dNdr(3,2)*x(i3,1) + dNdr(4,2)*x(i4,1)	! x,s
	  J(2,1) = dNdr(1,1)*x(i1,2) + dNdr(2,1)*x(i2,2) + &
		   dNdr(3,1)*x(i3,2) + dNdr(4,1)*x(i4,2)	! y,r
	  J(2,2) = dNdr(1,2)*x(i1,2) + dNdr(2,2)*x(i2,2) + &
		   dNdr(3,2)*x(i3,2) + dNdr(4,2)*x(i4,2)	! y,s

	  Jac  = J(1,1)*J(2,2) - J(1,2)*J(2,1)			! Jacobian determinant, |J|
	  Jaci = 1. / Jac					! 1/|J|

! inv(Jij)
	  Ji(1,1) = J(2,2)*Jaci
	  Ji(1,2) =-J(1,2)*Jaci
	  Ji(2,1) =-J(2,1)*Jaci
	  Ji(2,2) = J(1,1)*Jaci

	  do jj = 1,4
	    do m = 1,2		! direction loop
	      do k = 1,2	! direction loop
	        Qde1(ii,jj) = Qde1(ii,jj) - D(e,1,m) * dNdr(jj,k) * Ji(m,k)
	        Qde2(ii,jj) = Qde2(ii,jj) - D(e,2,m) * dNdr(jj,k) * Ji(m,k)
	      enddo	! k	
	    enddo	! m	
	  enddo		! jj
	enddo		! ii

	return
	end
